package editor;

import game.CustomImageDataII;
import game.EnemySprite;
import game.ItemSprite;
import game.PonyPanel;
import game.RainbowElementalSprite;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

import javax.sound.sampled.Clip;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;


public class RoomEditorPanel extends JPanel {
	
	
	private JScrollPane scrollCanvas;
	
	private EditorCanvas editorCanvas;
	
	private JScrollPane scrollPallette;
	
	private EditorPalette editorPalette;
	
	private StaticBlockCanvasObjectFactory staticBlockFactory;
	
	
	private HashMap<Character, StaticBlockCanvasObject> charactersToBlocks;
	
	private Stack<Character> charactersForCurrentRoom;
	
	private static final String allAllowedChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-=!@$%^&*()_+[]\\{}|;':\",./<>?";
	

	private ArrayList<ScreenObject> doorLayerObjects;
	
	private ArrayList<ScreenObject> commentaryLayerObjects;
	
	private ArrayList<ScreenObject> enemyLayerObjects;
	
	private ArrayList<ScreenObject> widgetLayerObjects;
	
	private MainEditorPanel mainPanel;
	
	
	private LayerControlPanel layerControlPanel;
	
	private JFrame frame;
	
	private boolean isStartRoom = false;
	
	private RoomListItem listItem;
	
	
	private HashMap<String, DoorLoadData> doorLoadPalette;
	private HashMap<String, DoorLoadData> incompleteDoorLoadPalette;
	private HashMap<String, DoorLoadData> commentDoorLoadPalette;
	private HashMap<String, DoorLoadData> incompleteCommentDoorLoadPalette;
	
	
	public RoomEditorPanel(MainEditorPanel theMainPanel, NewRoomSetupWizard wizard, RoomListItem theListItem) {
		
		mainPanel = theMainPanel;
		listItem = theListItem;
		
		
		this.addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(KeyEvent arg0) {
				if(arg0.getKeyCode() == KeyEvent.VK_C) {
					cloneCurrentSelection();
				}
				
			}
		}) ;
		
//		JDialog wizardFrame = new JDialog();
//		NewRoomSetupWizard wizard = new NewRoomSetupWizard(wizardFrame,
//											40, 40, 38, 14, new Color(128,128,0), Color.white, new Color(128, 64, 0), 
//											"C:\\WFMeltdown Project\\wfMeltdown\\src\\images\\blackSky.GIF", 
//											"C:\\WFMeltdown Project\\wfMeltdown\\src\\images\\applejackRoomBG2.GIF",
//											"testRoom");
//		wizardFrame.setContentPane(wizard);
//		
//		wizardFrame.setMinimumSize(new Dimension(600, 400));
//		wizardFrame.setMaximumSize(new Dimension(600, 400));
//		wizardFrame.setPreferredSize(new Dimension(600, 400));
//		
//		wizardFrame.setModal(true);
//		
//		wizardFrame.setVisible(true);
//		
//		if(wizard.wasCancelled()) {
//			throw new Exception("Wizard was cancelled!");
//		}
		
		
		editorCanvas = new EditorCanvas(wizard, this);
		scrollCanvas = new JScrollPane(editorCanvas);
		editorCanvas.setScrollPane(scrollCanvas);
		scrollCanvas.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener() {
			public void adjustmentValueChanged(AdjustmentEvent arg0) {
				editorCanvas.repaint();
			}
		});
		scrollCanvas.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener() {
			public void adjustmentValueChanged(AdjustmentEvent arg0) {
				editorCanvas.repaint();
			}
		});
		
		editorPalette = new EditorPalette(10, 5, 5, this);
		scrollPallette = new JScrollPane(editorPalette);
		editorPalette.setScrollPane(scrollPallette);
		
		charactersToBlocks = new HashMap<Character, StaticBlockCanvasObject>();
		
//		CustomImageDataII crate = new CustomImageDataII("/images/crateGif.GIF", Color.white, this);
//		CustomImageDataII caution = new CustomImageDataII("/images/cautionTile.GIF", Color.white, this);
//		CustomImageDataII fire = new CustomImageDataII("/images/fireTile.GIF", Color.white, this);
//		CustomImageDataII flower = new CustomImageDataII("/images/flowerTile.GIF", Color.white, this);
//		CustomImageDataII iron = new CustomImageDataII("/images/ironTile.GIF", Color.white, this);
//		CustomImageDataII hBlock = new CustomImageDataII("/images/mobBlockH.GIF", Color.white, this);
//		CustomImageDataII vBlock = new CustomImageDataII("/images/mobBlockV.GIF", Color.white, this);
//		CustomImageDataII brick = new CustomImageDataII("/images/redBrickTile.GIF", Color.white, this);
//		CustomImageDataII sapphire = new CustomImageDataII("/images/sapphireTile.GIF", Color.white, this);
//		CustomImageDataII tile = new CustomImageDataII("/images/tile.GIF", Color.white, this);
//		CustomImageDataII pass = new CustomImageDataII("/images/pass.GIF", Color.white, this);
		

//		charactersToBlocks.put('a', new StaticBlockCanvasObject(fire, true));
		
		
		CustomImageDataII newBlock = new CustomImageDataII("/images/new_static_block.GIF", Color.white, this);
		CustomImageDataII editBlock = new CustomImageDataII("/images/edit_static_block.GIF", Color.white, this);
		CustomImageDataII eraser = new CustomImageDataII("/images/eraser.GIF", Color.white, this);
		
		
		
		this.setMaximumSize(new Dimension(700, 500));
		this.setMinimumSize(new Dimension(700, 500));
		this.setPreferredSize(new Dimension(700, 500));
		
		
		this.setLayout(new BorderLayout());
		
//		JPanel nonLeftPanel = new JPanel();
//		nonLeftPanel.setLayout(new BorderLayout());
//		nonLeftPanel.add(scrollCanvas, BorderLayout.CENTER);
//		nonLeftPanel.add(scrollPallette, BorderLayout.SOUTH);
		JSplitPane nonLeftPanel = new JSplitPane(JSplitPane.VERTICAL_SPLIT, scrollCanvas, scrollPallette);
		nonLeftPanel.setDividerLocation(375);
		nonLeftPanel.setOneTouchExpandable(true);
		nonLeftPanel.getBottomComponent().setPreferredSize(new Dimension(500, 100));
		nonLeftPanel.setResizeWeight(1.0);
		
		layerControlPanel = new LayerControlPanel(this);
		this.add(layerControlPanel, BorderLayout.WEST);
		this.add(nonLeftPanel, BorderLayout.CENTER);
		
		
		
		
		charactersForCurrentRoom = new Stack<Character>();
		for(int i = allAllowedChars.length() - 1; i >= 0; i--) {
			charactersForCurrentRoom.push(allAllowedChars.charAt(i));
		}
		
		doorLayerObjects = new ArrayList<ScreenObject>();
		commentaryLayerObjects = new ArrayList<ScreenObject>();
		enemyLayerObjects = new ArrayList<ScreenObject>();
		widgetLayerObjects = new ArrayList<ScreenObject>();
		

		
		
//		editorPalette.addPaletteItem(newBlock);
//		editorPalette.addPaletteItem(editBlock);
//		editorPalette.addPaletteItem(eraser);
		
//		editorPalette.addPaletteItem(crate);
//		editorPalette.addPaletteItem(caution);
//		editorPalette.addPaletteItem(fire);
//		editorPalette.addPaletteItem(flower);
//		editorPalette.addPaletteItem(iron);
//		editorPalette.addPaletteItem(hBlock);
//		editorPalette.addPaletteItem(vBlock);
//		editorPalette.addPaletteItem(brick);
//		editorPalette.addPaletteItem(sapphire);
//		editorPalette.addPaletteItem(tile);
//		editorPalette.addPaletteItem(pass);
		
	}
	
	
	
//	public static void main(String [] args) {
//		
//		try {
//			JFrame theFrame = new JFrame();
//			
//			RoomEditorPanel p = new RoomEditorPanel();
//			
//			theFrame.setContentPane(p);
//			
//			
//			theFrame.setSize(new Dimension(707, 550));
//			
//			theFrame.setVisible(true);
//		} catch (Exception e) {
//			System.out.println("Exception!");
//			e.printStackTrace();
//		}
//		
//	}



	public StaticBlockCanvasObjectFactory getStaticBlockFactory() {
		return staticBlockFactory;
	}



	public void setStaticBlockFactory(
			StaticBlockCanvasObjectFactory staticBlockFactory) {
		this.staticBlockFactory = staticBlockFactory;
	}
	
	
	public char getNextChar() {
		if(charactersForCurrentRoom.isEmpty())
			return '\0';
		else
			return charactersForCurrentRoom.pop();
	}
	
	
	public HashMap<Character, StaticBlockCanvasObject> getCharactersToBlocks() {
		return charactersToBlocks;
	}
	
	
	public EditorPalette getEditorPalette() {
		return editorPalette;
	}
	
	public EditorCanvas getEditorCanvas() {
		return editorCanvas;
	}
	
	public CustomImageDataII getForegroundImage() {
		return staticBlockFactory.getForeground();
	}
	
	public CustomImageDataII getBackgroundImage() {
		return staticBlockFactory.getBackground();
	}
	
	public LayerControlPanel getLayerControlPanel() {
		return layerControlPanel;
	}
	
	
	public ArrayList<ScreenObject> getDoorLayerScreenObjects() {
		return doorLayerObjects;
	}
	
	
	public void unselectEverything() {
		//editorCanvas.useDefaultCursor();
		for(int i = 0; i < doorLayerObjects.size(); i++) {
			doorLayerObjects.get(i).setSelected(false);
		}
		for(int i = 0; i < enemyLayerObjects.size(); i++) {
			enemyLayerObjects.get(i).setSelected(false);
		}
		for(int i = 0; i < commentaryLayerObjects.size(); i++) {
			commentaryLayerObjects.get(i).setSelected(false);
		}
		for(int i = 0; i < widgetLayerObjects.size(); i++) {
			widgetLayerObjects.get(i).setSelected(false);
		}
	}
	
	public ArrayList<ScreenObject> getEnemyLayerScreenObjects() {
		return enemyLayerObjects;
	}
	
	public ArrayList<ScreenObject> getSelectedObjects() {
		
		ArrayList<ScreenObject> candidateObjects = null;
		ArrayList<ScreenObject> returnValue = new ArrayList<ScreenObject>();
		
		switch(layerControlPanel.getCurrentLayer()) {
		case LayerControlPanel.BLOCK_LAYER:
			return null;
		case LayerControlPanel.DOOR_LAYER:
			candidateObjects = doorLayerObjects;
			break;
		case LayerControlPanel.ENEMY_LAYER:
			candidateObjects = enemyLayerObjects;
			break;
		case LayerControlPanel.WIDGET_LAYER:
			candidateObjects = widgetLayerObjects;
			break;
		default:
			return null;
		}
		
		
		for(int i = 0; i < candidateObjects.size(); i++) {
			if(candidateObjects.get(i).isSelected())
				returnValue.add(candidateObjects.get(i));
		}
		
		return returnValue;
		
	}
	

	public boolean doesRainbowElementalAlreadyExist() {
		
		for(int i = 0; i < enemyLayerObjects.size(); i++) {
			if(enemyLayerObjects.get(i) == null)
				continue;
			if(enemyLayerObjects.get(i) instanceof RainbowBossScreenObject)
				return true;
		}
		
		return false;
		
	}
	
	public RainbowBossScreenObject getBoss() {
		for(int i = 0; i < enemyLayerObjects.size(); i++) {
			if(enemyLayerObjects.get(i) == null)
				continue;
			if(enemyLayerObjects.get(i) instanceof RainbowBossScreenObject)
				return (RainbowBossScreenObject) enemyLayerObjects.get(i);
		}
		
		return null;
	}
	
	public ArrayList<ScreenObject> getWidgetLayerScreenObjects() {
		return widgetLayerObjects;
	}
	
	public boolean doesGoalAlreadyExist() {
		for(int i = 0; i < widgetLayerObjects.size(); i++) {
			if(widgetLayerObjects.get(i) == null)
				continue;
			if(widgetLayerObjects.get(i) instanceof GoalScreenObject) {
				return true;
			}
			
		}
		return false;
	}
	
	
	public ArrayList<ScreenObject> getCommentaryLayerScreenObjects() {
		return commentaryLayerObjects;
	}
	
	public JFrame getFrame() {
		return frame;
	}
	public void setFrame(JFrame theFrame) {
		
		frame = theFrame;
		
		if(frame != null) {
			frame.addWindowListener(new WindowAdapter() {
				
				
				
				@Override
				public void windowClosing(WindowEvent arg0) {
					if(frame == null)
						return;
					frame.dispose();
					frame = null;
				}
				
				@Override
				public void windowClosed(WindowEvent arg0) {
					if(frame == null)
						return;
					frame.dispose();
					frame = null;
				}
				
				
			});
		} else {
			JOptionPane.showMessageDialog(null, "somehow, the frame was null...!");
		}
	}
	
	
	public String retrieveSummary() {
		
		StringBuffer returnValue = new StringBuffer("<html>");
		
		returnValue.append("Room name: ");
		returnValue.append(staticBlockFactory.getRoomName());
		returnValue.append("<br>");
		
		returnValue.append("<br>");
		
		returnValue.append("Width (in tiles): ");
		returnValue.append(staticBlockFactory.getBlocksWide());
		returnValue.append("<br>");
		
		returnValue.append("Height (in tiles): ");
		returnValue.append(staticBlockFactory.getBlocksHigh());
		returnValue.append("<br>");
		
		returnValue.append("Tile Width: ");
		returnValue.append(staticBlockFactory.getTileWidth());
		returnValue.append("<br>");
		
		returnValue.append("Tile Height: ");
		returnValue.append(staticBlockFactory.getTileHeight());
		returnValue.append("<br>");
		
		returnValue.append("Total number of static blocks:" );
		returnValue.append(editorCanvas.getCountOfStaticBlocks());
		returnValue.append("<br>");
		
		returnValue.append("Total number of moving/rogue blocks: ");
		returnValue.append(this.getMovingBlockCount() + this.getRogueBlockCount());
		returnValue.append("<br>");
		
		returnValue.append("<br>");
		
		returnValue.append("Total number of enemies: ");
		returnValue.append(this.getEnemyCount());
		returnValue.append("<br>");
		
		returnValue.append("Boss? ");
		switch(this.getTypeOfBoss()) {
		default:
			returnValue.append("No boss");
			break;
		case RainbowElementalSprite.NO_SPAWNING:
			returnValue.append("Easy; does not spawn enemies");
			break;
		case RainbowElementalSprite.SPAWN_TWO:
			returnValue.append("Mediuim; spawns two enemies");
			break;
		case RainbowElementalSprite.SPAWN_SIX:
			returnValue.append("Difficult; spawns six enemies");
			break;
		}
		returnValue.append("<br>");
		
		returnValue.append("<br>");
		
		returnValue.append("Contains checkpoint?  ");
		returnValue.append(this.containsCheckpoint() ? "yes" : "no");
		returnValue.append("<br>");
		
		returnValue.append("Contains goal?  ");
		returnValue.append(this.containsGoal() ? "yes" : "no");
		returnValue.append("<br>");
		
		returnValue.append("Outgoing doors?  ");
		returnValue.append(this.containsOutgoingDoor() ? "yes" : "no");
		returnValue.append("<br>");
		
		returnValue.append("Incoming doors?  ");
		returnValue.append(this.containsIncomingDoor() ? "yes" : "no");
		returnValue.append("<br>");
		
		
		
		return returnValue.toString();
		
	}
	
	public int getRogueBlockCount() {
		
		int returnValue = 0;
		
		if(enemyLayerObjects != null) {
			for(ScreenObject so : enemyLayerObjects) {
				if(so instanceof RogueBlockScreenObject)
					returnValue++;
			}
		}
		
		return returnValue;
		
	}
	
	public int getMovingBlockCount() {
		
		int returnValue = 0;
		
		if(enemyLayerObjects != null) {
			for(ScreenObject so : enemyLayerObjects) {
				if(so instanceof VerticalBlockScreenObject || so instanceof HorizontalBlockScreenObject)
					returnValue++;
			}
		}
		
		return returnValue;
		
	}
	
	public int getEnemyCount() {
		
		int returnValue = 0;
		
		if(enemyLayerObjects != null) {
			for(ScreenObject so : enemyLayerObjects) {
				if(so instanceof RedEnemyScreenObject 
						|| so instanceof YellowEnemyScreenObject
						|| so instanceof GreenEnemyScreenObject
						|| so instanceof BlueEnemyScreenObject
						|| so instanceof VioletEnemyScreenObject
						|| so instanceof GrayEnemyScreenObject)
					returnValue++;
			}
		}
		
		return returnValue;
		
	}
	
	
	public boolean containsIncomingDoor() {
		
		for(ScreenObject so : doorLayerObjects) {
			if(so instanceof DoorDestinationScreenObject) {
				String sourceName = ((DoorDestinationScreenObject) so).getNameOfSourceRoom();
				
				if(sourceName != null && !sourceName.equals(this.getListItem().getName()))
					return true;
			}
		}
		
		
		return false;
	}
	
	
	public boolean containsOutgoingDoor() {
		
		for(ScreenObject so : doorLayerObjects) {
			if(so instanceof DoorSourceScreenObject) {
				
				DoorSourceScreenObject dsso = (DoorSourceScreenObject) so;
				
				String targetRoomName = dsso.getTargetRoomPanel().getListItem().getName();
				if(targetRoomName == null || targetRoomName.equals(this.getListItem().getName()))
					continue;
				
				if(dsso.isConnected())
					return true;
				
				
			}
				
		}
		
		
		return false;
	}
	
	
	
	public int getTypeOfBoss() {
		
		if(enemyLayerObjects != null) {
			for(ScreenObject so : enemyLayerObjects) {
				if(so instanceof RainbowBossScreenObject) {
					return (((RainbowBossScreenObject)so).getType());
				}
			}
		}
		
		return -1;
		
	}
	
	public boolean containsCheckpoint() {
		
		if(doorLayerObjects != null) {
			for(ScreenObject so : doorLayerObjects) {
				if(so instanceof FlagScreenObject)
					return true;
			}
			for(ScreenObject so : enemyLayerObjects) {
				if(so instanceof RainbowBossScreenObject)
					return true;
			}
		}
		
		return false;
	}
	
	public boolean containsGoal() {
		
		if(widgetLayerObjects != null) {
			for(ScreenObject so : widgetLayerObjects) {
				if(so instanceof GoalScreenObject)
					return true;
			}
		}
		
		return false;
	}
	
	public MainEditorPanel getMainEditorPanel() {
		return mainPanel;
	}
	

	public boolean doorsShouldShowDestinationsAndSources() {
		return editorCanvas.doorsShouldShowDestinationsAndSources();
	}
	

	public DoorDestinationPaletteObject addDoorDestinationPointPaletteObject(RoomEditorPanel theSourceRoom, DoorSourcePaletteObject source) {
		layerControlPanel.switchToDoorLayer();
		return editorPalette.addDoorDestinationPointPaletteObject(theSourceRoom, source);
	}
	
	public DoorDestinationPaletteObject addCommentaryDoorDestinationPointPaletteObject(RoomEditorPanel theSourceRoom, DoorSourcePaletteObject source) {
		layerControlPanel.switchToCommentaryLayer();
		return editorPalette.addCommentaryDoorDestinationPointPaletteObject(theSourceRoom, source);
	}



	public boolean isStartRoom() {
		return isStartRoom;
	}



	public void setStartRoom(boolean isStartRoom) {
		this.isStartRoom = isStartRoom;
		listItem.updateIconAndColor();
	}
	
	
	public void closeWindow() {
		if(frame != null)
			frame.dispose();
//		else
//			System.out.println("oh dear!  the frame was NULL!!!");
	}
	
	public RoomListItem getListItem() {
		return this.listItem;
	}
	
	public Point retrieveLevelStart() {
		
		for(ScreenObject so : widgetLayerObjects) {
			if(so instanceof LevelStartScreenObject) {
				return so.getClickRect().getCenter();
			}
		}
		
		return null;
	}
	
	
	public void writeRoomToFile(BufferedWriter out) throws Exception {
		
		out.write("room:");
		out.newLine();
		
		out.write("roomName:");
		out.write(staticBlockFactory.getRoomName());
		out.newLine();
		
		out.write("bgColor:");
		out.write(CustomAnimationPanel.convertColorToString(staticBlockFactory.getOutOfBoundsColor()));
		out.newLine();
		
		out.newLine();
		
		
		
		//need to write out other stuff, like doors, widgets, enemies, blocks...
		
		for(ScreenObject so : this.getDoorLayerScreenObjects()) {
			if(so instanceof DoorSourceScreenObject) {
				((DoorSourceScreenObject) so).writeDoorOutToFile(out);
			} else if(so instanceof HeartScreenObject) {
				((HeartScreenObject) so).writeDoorOutToFile(out);
			} else if(so instanceof FlagScreenObject) {
				((FlagScreenObject) so).writeDoorOutToFile(out);
			} else if(so instanceof WidgetScreenObject) {
				((WidgetScreenObject) so).writeBgWidgetOutToFile(out);
			}
		}
		
		for(ScreenObject so : this.getCommentaryLayerScreenObjects()) {
			if(so instanceof RadioScreenObject) {
				((RadioScreenObject) so).writeOutToFile(out);
			} else if (so instanceof WidgetScreenObject) {
				((WidgetScreenObject) so).writeCommentWidgetOutToFile(out);
			} else if(so instanceof DoorSourceScreenObject) {
				((DoorSourceScreenObject) so).writeCommentDoorOutToFile(out);
			}
		}
		
		for(ScreenObject so : this.getEnemyLayerScreenObjects()) {
			if(so instanceof RedEnemyScreenObject) {
				((RedEnemyScreenObject) so).writeOutToFile(out);
			} else if(so instanceof BlueEnemyScreenObject) {
				((BlueEnemyScreenObject) so).writeOutToFile(out);
			} else if(so instanceof GreenEnemyScreenObject) {
				((GreenEnemyScreenObject) so).writeOutToFile(out);
			} else if(so instanceof GrayEnemyScreenObject) {
				((GrayEnemyScreenObject) so).writeOutToFile(out);
			} else if(so instanceof VioletEnemyScreenObject) {
				((VioletEnemyScreenObject) so).writeOutToFile(out);
			} else if(so instanceof YellowEnemyScreenObject) {
				((YellowEnemyScreenObject) so).writeOutToFile(out);
			} else if(so instanceof RainbowBossScreenObject) {
				((RainbowBossScreenObject) so).writeOutToFile(out);
			} else if(so instanceof HorizontalBlockScreenObject) {
				((HorizontalBlockScreenObject) so).writeOutToFile(out);
			} else if(so instanceof VerticalBlockScreenObject) {
				((VerticalBlockScreenObject) so).writeOutToFile(out);
			} else if(so instanceof RogueBlockScreenObject) {
				((RogueBlockScreenObject) so).writeOutToFile(out);
			} else if(so instanceof ConveyorScreenObject) {
				((ConveyorScreenObject) so).writeOutToFile(out);
			}
		}
		
		
		for(ScreenObject so : this.getWidgetLayerScreenObjects()) {
			if (so instanceof WidgetScreenObject) {
				((WidgetScreenObject) so).writeFgWidgetOutToFile(out);
			} else if(so instanceof GoalScreenObject) {
				((GoalScreenObject) so).writeOutToFile(out);
			} else if(so instanceof HurtzoneScreenObject) {
				((HurtzoneScreenObject) so).writeOutToFile(out);
			}
		}
		
		
		
		//static blocks
		out.newLine();
		
		out.write("staticBlocks");
		out.newLine();
		out.newLine();
		
		out.write("foreground:");
		out.write(this.staticBlockFactory.getForegroundFileName());
		out.write("*");
		out.write(CustomAnimationPanel.convertColorToString(this.staticBlockFactory.getTransparentColor()));
		out.newLine();
		
		out.write("unusedColor:");
		out.write(CustomAnimationPanel.convertColorToString(this.staticBlockFactory.getUnusedColor()));
		out.newLine();
		
		out.write("background:");
		out.write(this.staticBlockFactory.getBackgroundFileName());
		out.newLine();
		
		out.newLine();
		
		out.write("tileWidth:");
		out.write(Integer.toString(this.staticBlockFactory.getTileWidth()));
		out.newLine();
		
		out.write("tileHeight:");
		out.write(Integer.toString(this.staticBlockFactory.getTileHeight()));
		out.newLine();
		
		out.write("totalRows:");
		out.write(Integer.toString(this.staticBlockFactory.getBlocksHigh()));
		out.newLine();
		
		out.write("totalColumns:");
		out.write(Integer.toString(this.staticBlockFactory.getBlocksWide()));
		out.newLine();
		
		out.newLine();
		
		Set<Character> chars = charactersToBlocks.keySet();
		for(Character ch : chars) {
			out.write("blockDef:");
			out.write(ch.toString());
			out.newLine();
			out.write("graphic:");
			out.write(charactersToBlocks.get(ch).getImage().getFileName());
			out.newLine();
			out.write("transparent:");
			out.write(CustomAnimationPanel.convertColorToString(charactersToBlocks.get(ch).getImage().getTransparentColor()));
			out.newLine();
			if(charactersToBlocks.get(ch).isPassThrough()) {
				out.write("passThru");
			} else {
				out.write("solid");
			}
			out.newLine();
			out.write("/blockDef");
			out.newLine();
			out.newLine();
		}
		
		out.write("tileMap");
		out.newLine();
		
		for(int i = 0; i < editorCanvas.getStaticBlockMap().length; i++) {
			out.write(editorCanvas.getStaticBlockMap()[i]);
			out.newLine();
		}
		
		out.write("/staticBlocks");
		out.newLine();
		
		
		out.write("/room");
		out.newLine();
		out.newLine();
		out.newLine();
		
	}
	
	public RoomEditorPanel(BufferedReader in, MainEditorPanel theMainPanel, RoomListItem theListItem) throws Exception{
		

		this.setMaximumSize(new Dimension(700, 500));
		this.setMinimumSize(new Dimension(700, 500));
		this.setPreferredSize(new Dimension(700, 500));
		
		
		this.setLayout(new BorderLayout());
		
		mainPanel = theMainPanel;
		listItem = theListItem;
		
		
		charactersToBlocks = new HashMap<Character, StaticBlockCanvasObject>();

		charactersForCurrentRoom = new Stack<Character>();
		for(int i = allAllowedChars.length() - 1; i >= 0; i--) {
			charactersForCurrentRoom.push(allAllowedChars.charAt(i));
		}
		
		

		doorLayerObjects = new ArrayList<ScreenObject>();
		commentaryLayerObjects = new ArrayList<ScreenObject>();
		enemyLayerObjects = new ArrayList<ScreenObject>();
		widgetLayerObjects = new ArrayList<ScreenObject>();
		
		
		ArrayList<ScreenObjectAndDepth> doorLayerObjectsFiltered = new ArrayList<RoomEditorPanel.ScreenObjectAndDepth>();
		ArrayList<ScreenObjectAndDepth> commentLayerObjectsFiltered = new ArrayList<RoomEditorPanel.ScreenObjectAndDepth>();
		ArrayList<ScreenObjectAndDepth> enemyLayerObjectsFiltered = new ArrayList<RoomEditorPanel.ScreenObjectAndDepth>();
		ArrayList<ScreenObjectAndDepth> widgetLayerObjectsFiltered = new ArrayList<RoomEditorPanel.ScreenObjectAndDepth>();
		
		ScreenObjectAndDepth tempObjAndDepth = null;
		
		
		
		String inputter;
		String strArray[];
		Color newBgColor = null;
		int newTileWidth = -1;
		int newTileHeight = -1;
		String foregroundImage = null;
		String backgroundImage = null;
		Color transparentColor = null;
		Color newUnusedColor = null;
		char blockDefChar;
		StaticBlockCanvasObject tempStaticBlock;
		ArrayList<Character> charactersToBeAddedToPalette = new ArrayList<Character>();
		int totalRows = -1;
		int totalColumns = -1;
		String newRoomName = null;
		ArrayList<String> charMap = new ArrayList<String>();
		
		boolean tileMapMode = false;
		
		HashMap<String, WidgetLoadData> backgroundWidgetLoadPalette = new HashMap<String, WidgetLoadData>();
		doorLoadPalette = new HashMap<String, DoorLoadData>();
		incompleteDoorLoadPalette = new HashMap<String, DoorLoadData>();
		HashMap<String, RadioLoadData> radioPalette = new HashMap<String, RadioLoadData>();
		HashMap<String, WidgetLoadData> commentWidgetLoadPalette = new HashMap<String, WidgetLoadData>();
		commentDoorLoadPalette = new HashMap<String, DoorLoadData>();
		incompleteCommentDoorLoadPalette = new HashMap<String, DoorLoadData>();
		RainbowBossLoadData bossData = null;
		HashMap<String, RogueBlockLoadData> rogueBlockLoadPalette = new HashMap<String, RogueBlockLoadData>();
		HashMap<String, MovingBlockLoadData> movingBlockLoadPalette = new HashMap<String, MovingBlockLoadData>();
		HashMap<String, ConveyorLoadData> conveyorLoadPalette = new HashMap<String, ConveyorLoadData>();
		
		HashMap<String, WidgetLoadData> foregroundWidgetLoadPalette = new HashMap<String, WidgetLoadData>();
		GoalLoadData goalLoadData = null;
		
		HashMap<String, HurtzoneLoadData> hurtzoneLoadPalette = new HashMap<String, HurtzoneLoadData>();
		
		
//		HashMap<String, WidgetScreenPaletteObject> commentWidgetPalette = new HashMap<String, WidgetScreenPaletteObject>();
//		HashMap<String, WidgetScreenPaletteObject> foregroundWidgetPalette = new HashMap<String, WidgetScreenPaletteObject>();
		
//		ArrayList<WidgetScreenObject> backgroundWidgets = new ArrayList<WidgetScreenObject>();
//		ArrayList<WidgetScreenObject> commentWidgets = new ArrayList<WidgetScreenObject>();
//		ArrayList<WidgetScreenObject> foregroundWidgets = new ArrayList<WidgetScreenObject>();
		
		WidgetCounter doorLayerCounter = new WidgetCounter();
		WidgetCounter commentLayerCounter = new WidgetCounter();
		WidgetCounter enemyLayerCounter = new WidgetCounter();
		WidgetCounter widgetLayerCounter = new WidgetCounter();
		
		
		
		while((inputter = in.readLine()) != null) {
			
			
			if(inputter.contains("#")) {
				continue;
			} else if(inputter.contains("/room")) {
				break;
			} else if(tileMapMode) {
				
				if(inputter.contains("/staticBlocks")) {
					tileMapMode = false;
				} else {
					charMap.add(inputter);
				}
				
			} else {
			
				if(inputter.contains("roomName:")) {
					newRoomName = inputter.substring(9).trim();
				} else if(inputter.contains("bgColor:")) {
					newBgColor = CustomAnimationPanel.convertStringToColor(inputter.substring(8).trim());
				} else if(inputter.contains("tileWidth:")) {
					newTileWidth = Integer.parseInt(inputter.substring(10).trim());
				} else if(inputter.contains("tileHeight:")) {
					newTileHeight = Integer.parseInt(inputter.substring(11).trim());
				} else if(inputter.contains("foreground:")) {
					strArray = inputter.substring(11).split("\\*");
					foregroundImage = strArray[0].trim();//new CustomImageDataII(new File(strArray[0].trim()), CustomAnimationPanel.convertStringToColor(strArray[1].trim()), this);
					transparentColor = CustomAnimationPanel.convertStringToColor(strArray[1].trim());
				} else if(inputter.contains("unusedColor:")) {
					newUnusedColor = CustomAnimationPanel.convertStringToColor(inputter.substring(12).trim());
				} else if(inputter.contains("background:")) {
					backgroundImage = inputter.substring(11).trim();//new CustomImageDataII(new File(inputter.substring(11).trim()), null, this);
				} else if(inputter.contains("totalRows:")) {
					totalRows = Integer.parseInt(inputter.substring(10).trim());
				} else if(inputter.contains("totalColumns:")) {
					totalColumns = Integer.parseInt(inputter.substring(13).trim());
				} else if(inputter.contains("blockDef:")) {
					blockDefChar = inputter.charAt(9);
					tempStaticBlock = new StaticBlockCanvasObject(in, this, newTileWidth, newTileHeight);
					charactersToBlocks.put(new Character(blockDefChar), tempStaticBlock);
					charactersForCurrentRoom.remove(new Character(blockDefChar));
					//editorPalette.addStaticBlockPaletteItem(blockDefChar);
					charactersToBeAddedToPalette.add(blockDefChar);
				} else if(inputter.contains("tileMap")) {
					tileMapMode = true;
				} else if(inputter.contains("bgwidget:")) {
					loadWidget(in, backgroundWidgetLoadPalette, inputter, this, doorLayerCounter);
					
				} else if(inputter.contains("item:")) {
					loadItem(in);
				} else if(inputter.contains("comment_door")) {
					loadDoor(in, commentDoorLoadPalette, this, doorLayerCounter);
				} else if(inputter.contains("door")) {
					loadDoor(in, doorLoadPalette, this, doorLayerCounter);
				} else if(inputter.contains("comment_portaNoCompleta")) {
					loadIncompleteDoor(in, incompleteCommentDoorLoadPalette, this, doorLayerCounter);
				} else if(inputter.contains("portaNoCompleta")) {
					loadIncompleteDoor(in, incompleteDoorLoadPalette, this, doorLayerCounter);
				} else if(inputter.contains("radio")) {
					loadRadio(in, radioPalette, this, commentLayerCounter);
				} else if(inputter.contains("commentWidget:")) {
					loadWidget(in, commentWidgetLoadPalette, inputter, this, commentLayerCounter);
				} else if(inputter.contains("enemy:")) {
					loadEnemy(in, enemyLayerObjectsFiltered, enemyLayerCounter);
				} else if(inputter.contains("boss:")) {
					if(bossData == null) {
						bossData = loadBoss(in);
					}
				} else if(inputter.contains("block:")) {
					loadRogueBlock(in, rogueBlockLoadPalette, enemyLayerCounter);
				} else if(inputter.contains("movingBlock:")) {
					loadMovingBlock(in, movingBlockLoadPalette, enemyLayerCounter);
				} else if(inputter.contains("conveyor:")) {
					loadConveyor(in, conveyorLoadPalette, enemyLayerCounter);
				} else if(inputter.contains("fgwidget:")) {
					loadWidget(in, foregroundWidgetLoadPalette, inputter, this, widgetLayerCounter);
				} else if(inputter.contains("goal:")) {
					goalLoadData = loadGoal(in);
				} else if(inputter.contains("hurtzone:")) {
					loadHurtzone(in, hurtzoneLoadPalette);
				}
			}
			
		}
		
		
		
		NewRoomDataObject wizard = new NewRoomDataObject();
		wizard.setTileWidth(newTileWidth);
		wizard.setTileHeight(newTileHeight);
		wizard.setRoomName(listItem.getName());
		wizard.setRoomWidth(totalColumns);
		wizard.setRoomHeight(totalRows);
		wizard.setBackgroundImageName(backgroundImage);
		wizard.setForegroundImageName(foregroundImage);
		wizard.setOutOfBoundsColor(newBgColor);
		wizard.setTransparentColor(transparentColor);
		wizard.setUnusedColor(newUnusedColor);
		

		editorCanvas = new EditorCanvas(wizard, this);
		scrollCanvas = new JScrollPane(editorCanvas);
		editorCanvas.setScrollPane(scrollCanvas);
		scrollCanvas.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener() {
			public void adjustmentValueChanged(AdjustmentEvent arg0) {
				editorCanvas.repaint();
			}
		});
		scrollCanvas.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener() {
			public void adjustmentValueChanged(AdjustmentEvent arg0) {
				editorCanvas.repaint();
			}
		});
//		if(staticBlockFactory == null) {
//			System.out.println("'twas null!");
//		} else {
//			System.out.println("not null!");
//		}
		this.staticBlockFactory.setRoomName(newRoomName);
		
		
		editorPalette = new EditorPalette(10, 5, 5, this);
		scrollPallette = new JScrollPane(editorPalette);
		editorPalette.setScrollPane(scrollPallette);
		
//		JPanel nonLeftPanel = new JPanel();
//		nonLeftPanel.setLayout(new BorderLayout());
//		nonLeftPanel.add(scrollCanvas, BorderLayout.CENTER);
//		nonLeftPanel.add(scrollPallette, BorderLayout.SOUTH);
		JSplitPane nonLeftPanel = new JSplitPane(JSplitPane.VERTICAL_SPLIT, scrollCanvas, scrollPallette);
		nonLeftPanel.setDividerLocation(375);
		nonLeftPanel.setOneTouchExpandable(true);
		nonLeftPanel.getBottomComponent().setPreferredSize(new Dimension(500, 100));
		nonLeftPanel.setResizeWeight(1.0);
		
		
		layerControlPanel = new LayerControlPanel(this);
		this.add(layerControlPanel, BorderLayout.WEST);
		this.add(nonLeftPanel, BorderLayout.CENTER);
		
		
		for(Character ch : charactersToBeAddedToPalette) {
			editorPalette.addStaticBlockPaletteItem(ch);
		}
		
		
		for(int y = 0; y < charMap.size(); y++) {
			
//			System.out.println("now loading up the charMap at index y: " + y + ", map is: <<" + charMap.get(y) + ">>");
			
			for(int x = 0; x < charMap.get(y).length(); x++) {
				
				editorCanvas.getStaticBlockMap()[y][x] = charMap.get(y).charAt(x);
				
			}
			
		}
		
		Set<String> allBgWidgetKeys = backgroundWidgetLoadPalette.keySet();
		WidgetLoadData tempWDL = null;
		ArrayList<SpawnPointAndDepth> spawnPoints = null;
		WidgetScreenPaletteObject tempWidgetPaletteObject = null;
		ScreenObject tempScreenObject = null;
		for(String bgWidgetKey : allBgWidgetKeys) {
			
			tempWDL = backgroundWidgetLoadPalette.get(bgWidgetKey);
			
			tempWidgetPaletteObject = editorPalette.addBgWidget(tempWDL.getImageArray());
			
			spawnPoints = tempWDL.getSpawnPoints();
			for(Point p : spawnPoints) {
				tempScreenObject = tempWidgetPaletteObject.create(p.x, p.y, this);
//				this.doorLayerObjects.add(tempScreenObject);
				doorLayerObjectsFiltered.add(new ScreenObjectAndDepth(tempScreenObject, ((SpawnPointAndDepth)p).depth));
			}
			
		}
		
		
		Set<String> allCommentWidgetKeys = commentWidgetLoadPalette.keySet();
		tempWDL = null;
		spawnPoints = null;
		tempWidgetPaletteObject = null;
		tempScreenObject = null;
		for(String commentWidgetKey : allCommentWidgetKeys) {
			
			tempWDL = commentWidgetLoadPalette.get(commentWidgetKey);
			
			tempWidgetPaletteObject = editorPalette.addCommentWidget(tempWDL.getImageArray());
			
			spawnPoints = tempWDL.getSpawnPoints();
			for(Point p : spawnPoints) {
				tempScreenObject = tempWidgetPaletteObject.create(p.x, p.y, this);
//				this.commentaryLayerObjects.add(tempScreenObject);
				commentLayerObjectsFiltered.add(new ScreenObjectAndDepth(tempScreenObject, ((SpawnPointAndDepth)p).depth));
			}
		}
		
		
		Set<String> allRadioKeys = radioPalette.keySet();
		RadioLoadData tempRLD = null;
		spawnPoints = null;
		RadioScreenPaletteObject tempRadioPaletteObject = null;
		tempScreenObject = null;
		for(String radioKey : allRadioKeys) {
			
			tempRLD = radioPalette.get(radioKey);
			
			tempRadioPaletteObject = editorPalette.addRadio(tempRLD.getWaveFile(), tempRLD.getCaption(), tempRLD.getCaptionColor(), tempRLD.getSoundClip());
			
			spawnPoints = tempRLD.getSpawnPoints();
			for(Point p : spawnPoints) {
				tempScreenObject = tempRadioPaletteObject.create(p.x, p.y, this);
//				this.commentaryLayerObjects.add(tempScreenObject);
				commentLayerObjectsFiltered.add(new ScreenObjectAndDepth(tempScreenObject, ((SpawnPointAndDepth)p).depth));
			}
			
			
		}
		
		
		
//		System.out.println("THERE ARE THIS MANY ROGUE BLOCK KEYS:  " + rogueBlockLoadPalette.size());
		
		Set<String> allRogueBlockKeys = rogueBlockLoadPalette.keySet();
		RogueBlockLoadData tempRBLD = null;
		spawnPoints = null;
		RogueBlockScreenPaletteObject tempRogueBlockPaletteObject = null;
		tempScreenObject = null;
		for(String key : allRogueBlockKeys) {
			
			tempRBLD = rogueBlockLoadPalette.get(key);
			
			tempRogueBlockPaletteObject = editorPalette.addRogueBlock(tempRBLD.getWidth(), tempRBLD.getHeight(), tempRBLD.getImage(), tempRBLD.getTransparent(), tempRBLD.isPassThru());
			
			
			spawnPoints = tempRBLD.getSpawnPoints();
			for(Point p : spawnPoints) {
				tempScreenObject = tempRogueBlockPaletteObject.create(p.x, p.y, this);
//				this.enemyLayerObjects.add(tempScreenObject);
				enemyLayerObjectsFiltered.add(new ScreenObjectAndDepth(tempScreenObject, ((SpawnPointAndDepth)p).depth));
			}
		}
		

		if(bossData != null) {
			RainbowBossScreenPaletteObject po = editorPalette.getRainbowElementalPaletteObject();
			RainbowBossScreenObject so = (RainbowBossScreenObject) po.create(bossData.getFocusX(), bossData.getFocusY() - 200, this);
			so.setFlagSpawnPoint(new Point(bossData.getSafeX(), bossData.getSafeY()));
			so.setType(bossData.getKind());
//			enemyLayerObjects.add(so);
			enemyLayerObjectsFiltered.add(new ScreenObjectAndDepth(so, -1));
		}
		
		Set<String> allMovingBlockKeys = movingBlockLoadPalette.keySet();
		MovingBlockLoadData tempMBLD = null;
		HorizontalBlockScreenPaletteObject tempHorizontalBlockPaletteObject = null;
		VerticalBlockScreenPaletteObject tempVerticalBlockPaletteObject = null;
		ArrayList<MovingBlockPointData> movingBlockSpawnPoints = null;
		VerticalBlockScreenObject tempVerticalBlock = null;
		HorizontalBlockScreenObject tempHorizontalBlock = null;
		
		for(String key : allMovingBlockKeys) {
			
			tempMBLD = movingBlockLoadPalette.get(key);
			
			if(tempMBLD.isVertical()) {
				
				tempVerticalBlockPaletteObject = editorPalette.addVerticalMovingBlock(tempMBLD.getWidth(), tempMBLD.getHeight(), tempMBLD.getImage(), tempMBLD.getTransparentColor(), tempMBLD.getIsPassThru(), tempMBLD.getDefaultSpeed());
				
				movingBlockSpawnPoints = tempMBLD.getSpawnPoints();
				
				for(MovingBlockPointData p : movingBlockSpawnPoints) {
					tempVerticalBlock = (VerticalBlockScreenObject) tempVerticalBlockPaletteObject.create(p.x, p.y, this);
					tempVerticalBlock.setMax(p.max);
					tempVerticalBlock.setMin(p.min);
					tempVerticalBlock.setGoingMinDirection(p.dir == 'u');
					tempVerticalBlock.setSpeed(p.speed);
					
//					this.enemyLayerObjects.add(tempVerticalBlock);
					
					enemyLayerObjectsFiltered.add(new ScreenObjectAndDepth(tempVerticalBlock, p.depth));
					
				}
				
				
			} else {

				tempHorizontalBlockPaletteObject = editorPalette.addHorizontalMovingBlock(tempMBLD.getWidth(), tempMBLD.getHeight(), tempMBLD.getImage(), tempMBLD.getTransparentColor(), tempMBLD.getIsPassThru(), tempMBLD.getDefaultSpeed());
				
				movingBlockSpawnPoints = tempMBLD.getSpawnPoints();
				
				for(MovingBlockPointData p : movingBlockSpawnPoints) {
					tempHorizontalBlock = (HorizontalBlockScreenObject) tempHorizontalBlockPaletteObject.create(p.x, p.y, this);
					tempHorizontalBlock.setMax(p.max);
					tempHorizontalBlock.setMin(p.min);
					tempHorizontalBlock.setGoingMinDirection(p.dir == 'l');
					tempHorizontalBlock.setSpeed(p.speed);
					
//					this.enemyLayerObjects.add(tempHorizontalBlock);
					
					enemyLayerObjectsFiltered.add(new ScreenObjectAndDepth(tempHorizontalBlock, p.depth));
				}
				
				
			}
			
		}
		
		
		//move enemies to the end of the list
		/*ArrayList<ScreenObject> tempEnemyList = new ArrayList<ScreenObject>();
		for(int i = 0; i < enemyLayerObjects.size(); i++) {
			if(enemyLayerObjects.get(i) instanceof RedEnemyScreenObject
					|| enemyLayerObjects.get(i) instanceof YellowEnemyScreenObject
					|| enemyLayerObjects.get(i) instanceof GreenEnemyScreenObject
					|| enemyLayerObjects.get(i) instanceof BlueEnemyScreenObject
					|| enemyLayerObjects.get(i) instanceof VioletEnemyScreenObject
					|| enemyLayerObjects.get(i) instanceof GrayEnemyScreenObject) {
				tempEnemyList.add(enemyLayerObjects.remove(i));
				i--;
			}
		}
		*/
		//BOOKMARK want to add items here, or else move the enemyLayerObjects.add calls further down...
		
		
		/*for(ScreenObject so : tempEnemyList) {
			enemyLayerObjects.add(so);
		}*/
		
		
		
		
		Collections.sort(doorLayerObjectsFiltered);
		
		
		for(ScreenObjectAndDepth s : doorLayerObjectsFiltered) {
			this.doorLayerObjects.add(s.toBeAdded);
		}
		
		
		
		
		
		Collections.sort(commentLayerObjectsFiltered);
		
		
		for(ScreenObjectAndDepth s : commentLayerObjectsFiltered) {
			this.commentaryLayerObjects.add(s.toBeAdded);
		}
		
		
		

		/*if(bossData != null) {
			RainbowBossScreenPaletteObject po = editorPalette.getRainbowElementalPaletteObject();
			RainbowBossScreenObject so = (RainbowBossScreenObject) po.create(bossData.getFocusX(), bossData.getFocusY() - 200, this);
			
			if(so == null) {
				System.err.println("Here it is!!!");
			}
			
			
			so.setFlagSpawnPoint(new Point(bossData.getSafeX(), bossData.getSafeY()));
			so.setType(bossData.getKind());
			enemyLayerObjects.add(so);
		}*/
		
		
		Set<String> allConveyorKeys = conveyorLoadPalette.keySet();
		ConveyorLoadData tempCLD = null;
		ConveyorPaletteObject tempConveyorPaletteObject = null;
		tempScreenObject = null;
		spawnPoints = null;
//		String fileNameArray[] = null;
//		Color transColorArray[] = null;
		CustomImageDataII cidArray[] = null;
		for(String key : allConveyorKeys) {
			
			tempCLD = conveyorLoadPalette.get(key);
			
			cidArray = new CustomImageDataII[tempCLD.getImages().length];
			for(int i = 0; i < cidArray.length; i++) {
				cidArray[i] = new CustomImageDataII(new File(tempCLD.getImages()[i]), tempCLD.getTransparentColors()[i], this, tempCLD.getWidth(), tempCLD.getHeight());
			}
			
			tempConveyorPaletteObject = editorPalette.addConveyorPalette(cidArray, tempCLD.getWidth(), tempCLD.getHeight(), tempCLD.getSpeed(), tempCLD.getDir(), tempCLD.getIsPassThru());
			
			spawnPoints = tempCLD.getSpawnPoints();
			
			for(Point p : spawnPoints) {
				tempScreenObject = tempConveyorPaletteObject.create(p.x, p.y, this);
//				this.enemyLayerObjects.add(tempScreenObject);
				enemyLayerObjectsFiltered.add(new ScreenObjectAndDepth(tempScreenObject, ((SpawnPointAndDepth)p).depth));
			}
		}
		
		
		
		
		

		
		Collections.sort(enemyLayerObjectsFiltered);
		
		
		for(ScreenObjectAndDepth s : enemyLayerObjectsFiltered) {
			this.enemyLayerObjects.add(s.toBeAdded);
		}
		
		
		
		
		Set<String> allForegroundWidgetKeys = foregroundWidgetLoadPalette.keySet();
		tempWDL = null;
		spawnPoints = null;
		tempWidgetPaletteObject = null;
		tempScreenObject = null;
		for(String commentWidgetKey : allForegroundWidgetKeys) {
			
			tempWDL = foregroundWidgetLoadPalette.get(commentWidgetKey);
			
			tempWidgetPaletteObject = editorPalette.addFgWidget(tempWDL.getImageArray());
			
			spawnPoints = tempWDL.getSpawnPoints();
			for(Point p : spawnPoints) {
				tempScreenObject = tempWidgetPaletteObject.create(p.x, p.y, this);
//				this.widgetLayerObjects.add(tempScreenObject);
				tempObjAndDepth = new ScreenObjectAndDepth(tempScreenObject, ((SpawnPointAndDepth)p).depth);
				widgetLayerObjectsFiltered.add(tempObjAndDepth);
			}
		}
		
		
		Collections.sort(widgetLayerObjectsFiltered);
		
		
		for(ScreenObjectAndDepth s : widgetLayerObjectsFiltered) {
			this.widgetLayerObjects.add(s.toBeAdded);
		}
		
		
		
		if(goalLoadData != null) {
			
			GoalScreenPaletteObject gspo = editorPalette.getGoalPalette();
			
			if(gspo != null) {
				
				CustomImageDataII imageArray[] = new CustomImageDataII[goalLoadData.getImages().length];
				
				for(int i = 0; i < imageArray.length; i++) {
					imageArray[i] = new CustomImageDataII(new File(goalLoadData.getImages()[i]), null, this, PonyPanel.PLAY_AREA_WIDTH, PonyPanel.PANEL_HEIGHT);
				}
				
				gspo.setCutscene(imageArray);
				gspo.setPassThru(goalLoadData.getIsPassThru());
				gspo.setEnableCommentary(goalLoadData.shouldEnableCommentary());
				
				GoalScreenObject gso = (GoalScreenObject) gspo.create(goalLoadData.getX(), goalLoadData.getY(), this);
				this.widgetLayerObjects.add(gso);
				
				
			}
			
		}
		
		
		Set<String> allHurtzoneKeys = hurtzoneLoadPalette.keySet();
		HurtzoneLoadData hzld = null;
		ArrayList<HurtzonePointData> hzldPoints = null;
		HurtzonePaletteObject tempHzpo = null;
		HurtzoneScreenObject tempHzso = null;
		for(String hurtzoneKey : allHurtzoneKeys) {
			
			hzld = hurtzoneLoadPalette.get(hurtzoneKey);
			
			tempHzpo = this.editorPalette.addHurtzone(hzld.isVertical(), hzld.getDuration(), hzld.getTimeBetweenFirings(), hzld.getFireChanceNumerator(), hzld.getFireChanceDenominator(), hzld.getWarmupTime(), hzld.getDamage(), hzld.getMinColor(), hzld.getMaxColor());
			
			hzldPoints = hzld.getPoints();
			
			for(HurtzonePointData hzpd : hzldPoints) {
				
				tempHzso = (HurtzoneScreenObject) tempHzpo.create(hzpd.getX(), hzpd.getY(), editorCanvas);
				tempHzso.setMax(hzpd.getMax());
				tempHzso.setMin(hzpd.getMin());
				
				this.widgetLayerObjects.add(tempHzso);
				
			}
			
		}
		
		
		
//		CustomImageDataII crate = new CustomImageDataII("/images/crateGif.GIF", Color.white, this);
//		CustomImageDataII caution = new CustomImageDataII("/images/cautionTile.GIF", Color.white, this);
//		CustomImageDataII fire = new CustomImageDataII("/images/fireTile.GIF", Color.white, this);
//		CustomImageDataII flower = new CustomImageDataII("/images/flowerTile.GIF", Color.white, this);
//		CustomImageDataII iron = new CustomImageDataII("/images/ironTile.GIF", Color.white, this);
//		CustomImageDataII hBlock = new CustomImageDataII("/images/mobBlockH.GIF", Color.white, this);
//		CustomImageDataII vBlock = new CustomImageDataII("/images/mobBlockV.GIF", Color.white, this);
//		CustomImageDataII brick = new CustomImageDataII("/images/redBrickTile.GIF", Color.white, this);
//		CustomImageDataII sapphire = new CustomImageDataII("/images/sapphireTile.GIF", Color.white, this);
//		CustomImageDataII tile = new CustomImageDataII("/images/tile.GIF", Color.white, this);
//		CustomImageDataII pass = new CustomImageDataII("/images/pass.GIF", Color.white, this);
		

//		charactersToBlocks.put('a', new StaticBlockCanvasObject(fire, true));
		
		
//		CustomImageDataII newBlock = new CustomImageDataII("/images/new_static_block.GIF", Color.white, this);
//		CustomImageDataII editBlock = new CustomImageDataII("/images/edit_static_block.GIF", Color.white, this);
//		CustomImageDataII eraser = new CustomImageDataII("/images/eraser.GIF", Color.white, this);
		
		
		
		
		
		
	}
	
	
	public void loadItem(BufferedReader in) throws Exception {
		
		String inputter = null;
		int x = -1;
		int y = -1;
		int kind = -1;
		
		while((inputter = in.readLine()) != null) {
			if(inputter.contains("#"))
				continue;
			else if (inputter.contains("/item"))
				break;
			else if(inputter.contains("x:")) {
				x = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("y:")) {
				y = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("heart")) {
				kind = ItemSprite.HEART;
			} else if(inputter.contains("checkpoint")) {
				kind = ItemSprite.CHECKPOINT_FLAG;
			}
		}
		
		if(x != -1 && y != -1 && kind != -1) {
			
			switch(kind) {
			case ItemSprite.HEART:
				HeartScreenObject hso = new HeartScreenObject(x, y, this);
				doorLayerObjects.add(hso);
				break;
			case ItemSprite.CHECKPOINT_FLAG:
				FlagScreenObject fso = new FlagScreenObject(x, y, this);
				doorLayerObjects.add(fso);
				break;
			}
			
		}
	}
	
	public void loadWidget(BufferedReader in, 
			HashMap<String, WidgetLoadData> widgetPalette, String layer, ImageObserver io, WidgetCounter counter) throws Exception {
		
		StringBuffer key = new StringBuffer();
		
		key.append(layer);
		key.append("\n");
		
		String inputter = null;
		
		int xPos = -1;
		int yPos = -1;
		
		int countOfFrames = -1;
		CustomImageDataII images[] = null;
		String strArray[] = null;
		
		while((inputter = in.readLine()) != null) {
			if(inputter.contains("/widget")) {
				break;
			} else if(inputter.contains("#"))
				continue;
			if(countOfFrames != -1) {
				key.append(inputter);
				key.append("\n");
				strArray = inputter.split("\\*");
				if(strArray.length < 4)
					images[countOfFrames] = new CustomImageDataII(new File(strArray[0].trim()), CustomAnimationPanel.convertStringToColor(strArray[1].trim()), io);
				else
					images[countOfFrames] = new CustomImageDataII(new File(strArray[0].trim()), CustomAnimationPanel.convertStringToColor(strArray[1].trim()), io, Integer.parseInt(strArray[2].trim()), Integer.parseInt(strArray[3].trim()));
				countOfFrames++;
			} else {
				if(inputter.contains("x:")) {
					xPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("y:")) {
					yPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("frameCount:")) {
					countOfFrames = Integer.parseInt(inputter.substring(11));
					images = new CustomImageDataII[countOfFrames];
					countOfFrames = 0;
					key.append(inputter);
					key.append("\n");
				}
			}
		}
		
		
		String keyStr = key.toString();
		
		if(widgetPalette.containsKey(keyStr)) {
			
			WidgetLoadData po = widgetPalette.get(keyStr);
			
			po.addSpawnPoint(new SpawnPointAndDepth(xPos, yPos, counter.getInt()));
			counter.increment();
			
			
		} else {
			
			//gotta make a new palette object!  Yeeg...
			WidgetLoadData po = new WidgetLoadData();
			po.setImageArray(images);
			po.addSpawnPoint(new SpawnPointAndDepth(xPos, yPos, counter.getInt()));
			counter.increment();
			
			widgetPalette.put(keyStr, po);
		}
		
	}
	
	
	public void loadDoor(BufferedReader in, HashMap<String, DoorLoadData> doorPalette, ImageObserver io, WidgetCounter counter) throws Exception {
		
//		System.out.println("now in loadDoor!");
		
		String inputter = null;

		StringBuffer key = new StringBuffer();
		
		int doorX = -1;
		int doorY = -1;
		CustomImageDataII image = null;
		String strArray[] = null;
		String destinationRoom = null;
		int destinationX = -1;
		int destinationY = -1;
		
		
		
		while((inputter = in.readLine()) != null) {
			if(inputter.contains("#")) {
				continue;
			} else if(inputter.contains("/door")) {
				break;
			} else {
				
				boolean shouldAppendInputter = true;
				
				if(inputter.contains("x:")) {
					doorX = Integer.parseInt(inputter.substring(2).trim());
					shouldAppendInputter = false;
				} else if(inputter.contains("y:")) {
					doorY = Integer.parseInt(inputter.substring(2).trim());
					shouldAppendInputter = false;
				} else if(inputter.contains("graphic:"))  {
					strArray = inputter.substring(8).trim().split("\\*");
					image = new CustomImageDataII(new File(strArray[0].trim()), CustomAnimationPanel.convertStringToColor(strArray[1].trim()), io);
				} else if(inputter.contains("destinationRoom:")) {
					destinationRoom = inputter.substring(16).trim();
				} else if(inputter.contains("destinationX:")) {
					destinationX = Integer.parseInt(inputter.substring(13).trim());
				} else if(inputter.contains("destinationY:")) {
					destinationY = Integer.parseInt(inputter.substring(13).trim());
				}
				
				if(shouldAppendInputter) {
					key.append(inputter);
					key.append("\n");
				}
			}
		}
		
		
		if(doorX != -1 
				&& doorY != -1
				&& image != null
				&& destinationRoom != null
				&& destinationX != -1
				&& destinationY != -1) {
			
			if(doorPalette.containsKey(key.toString())) {
				
				DoorLoadData dld = doorPalette.get(key.toString());
				dld.addSourcePoint(new SpawnPointAndDepth(doorX, doorY, counter.getInt()));
				counter.increment();
				
			} else {
				
				DoorLoadData dld = new DoorLoadData();
				dld.setDestination(new Point(destinationX, destinationY));
				dld.setDoorImage(image);
				dld.setDestinationRoom(destinationRoom);
				dld.addSourcePoint(new SpawnPointAndDepth(doorX, doorY, counter.getInt()));
				counter.increment();
				
				doorPalette.put(key.toString(), dld);
//				System.out.println("just added a door at " + doorX + "," + doorY + ", going to " + destinationRoom + " at " + destinationX + "," + destinationY + ".  Is the image null? " + (image == null));
			}
			
		} else {
//			System.err.println("unable to load door; some of these were null!  destinationRoom: " + destinationRoom + ", destinationX: " + destinationX + ", destinationY: " + destinationY);
		}
		
	}



	

	public void loadIncompleteDoor(BufferedReader in, HashMap<String, DoorLoadData> doorPalette, ImageObserver io, WidgetCounter counter) throws Exception {
		
//		System.out.println("now in loadIncompleteDoor!");
		
		String inputter = null;

		StringBuffer key = new StringBuffer();
		
		int doorX = -1;
		int doorY = -1;
		CustomImageDataII image = null;
		String strArray[] = null;
		String destinationRoom = null;
//		int destinationX = -1;
//		int destinationY = -1;
		
		
		
		while((inputter = in.readLine()) != null) {
			if(inputter.contains("#")) {
				continue;
			} else if(inputter.contains("/portaNoCompleta")) {
				break;
			} else {
				
				boolean shouldAppendInputter = true;
				
				if(inputter.contains("x:")) {
					doorX = Integer.parseInt(inputter.substring(2).trim());
					shouldAppendInputter = false;
				} else if(inputter.contains("y:")) {
					doorY = Integer.parseInt(inputter.substring(2).trim());
					shouldAppendInputter = false;
				} else if(inputter.contains("graphic:"))  {
					strArray = inputter.substring(8).trim().split("\\*");
					image = new CustomImageDataII(new File(strArray[0].trim()), CustomAnimationPanel.convertStringToColor(strArray[1].trim()), io);
				} else if(inputter.contains("destinationRoom:")) {
					destinationRoom = inputter.substring(16).trim();
//				} else if(inputter.contains("destinationX:")) {
//					destinationX = Integer.parseInt(inputter.substring(13).trim());
//				} else if(inputter.contains("destinationY:")) {
//					destinationY = Integer.parseInt(inputter.substring(13).trim());
				}
				
				if(shouldAppendInputter) {
					key.append(inputter);
					key.append("\n");
				}
			}
		}
		
		
		if(doorX != -1 
				&& doorY != -1
				&& image != null
				&& destinationRoom != null
//				&& destinationX != -1
//				&& destinationY != -1
				) {
			
			if(doorPalette.containsKey(key.toString())) {
				
				DoorLoadData dld = doorPalette.get(key.toString());
				dld.addSourcePoint(new SpawnPointAndDepth(doorX, doorY, counter.getInt()));
				counter.increment();
				
			} else {
				
				DoorLoadData dld = new DoorLoadData();
//				dld.setDestination(new Point(destinationX, destinationY));
				dld.setDoorImage(image);
				dld.setDestinationRoom(destinationRoom);
				dld.addSourcePoint(new SpawnPointAndDepth(doorX, doorY, counter.getInt()));
				counter.increment();
				
				doorPalette.put(key.toString(), dld);
//				System.out.println("just added an incomplete door at " + doorX + "," + doorY + ", going to " + destinationRoom + ".  Is the image null? " + (image == null));
			}
			
		} else {
//			System.err.println("unable to load incomplete door; some of these were null!  destinationRoom: " + destinationRoom );
		}
		
	}

	

	public void loadRadio(BufferedReader in, 
			HashMap<String, RadioLoadData> radioPalette, ImageObserver io, WidgetCounter counter) throws Exception {
		
		StringBuffer key = new StringBuffer();
		
		String inputter = null;
		
		int xPos = -1;
		int yPos = -1;
		
		String caption = null;
		Color captionColor = null;
		String waveFile = null;
		Clip soundClip = null;
		
		while((inputter = in.readLine()) != null) {
			if(inputter.contains("/r")) {
				break;
			} else if(inputter.contains("#"))
				continue;
			
			if(inputter.contains("x:")) {
				xPos = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("y:")) {
				yPos = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("sound:")) {
				waveFile = inputter.substring(6).trim();
				soundClip = NewRadioPaletteObjectWizard.loadGivenClip(waveFile);
				key.append(inputter);
				key.append("\n");
			} else if(inputter.contains("caption:")) {
				caption = inputter.substring(8).trim();
				key.append(inputter);
				key.append("\n");
			} else if(inputter.contains("captionColor:")) {
				captionColor = CustomAnimationPanel.convertStringToColor(inputter.substring(13).trim());
				key.append(inputter);
				key.append("\n");
			}
			
		}
		
		
		String keyStr = key.toString();
		
		if(radioPalette.containsKey(keyStr)) {
			
			RadioLoadData po = radioPalette.get(keyStr);
			
			po.addSpawnPoint(new SpawnPointAndDepth(xPos, yPos, counter.getInt()));
			counter.increment();
			
		} else {
			
			//gotta make a new palette object!  Yeeg...
			RadioLoadData po = new RadioLoadData();
			if(caption != null && captionColor != null) {
				po.setCaption(caption);
				po.setCaptionColor(captionColor);
			}
			po.setWaveFile(waveFile);
			po.setSoundClip(soundClip);
			po.addSpawnPoint(new SpawnPointAndDepth(xPos, yPos, counter.getInt()));
			counter.increment();
			
			radioPalette.put(keyStr, po);
		}
		
	}
	
	
	
	
	public HashMap<String, DoorLoadData> getDoorLoadPalette() {
		return doorLoadPalette;
	}
	
	
	
	public HashMap<String, DoorLoadData> getIncompleteDoorLoadPalette() {
		return incompleteDoorLoadPalette;
	}
	
	public HashMap<String, DoorLoadData> getIncompleteCommentDoorLoadPalette() {
		return incompleteCommentDoorLoadPalette;
	}



	public void setDestinationDoorSpawnPoint(DoorDestinationPaletteObject paletteObject, Point destPoint) {
		
		
		if(!editorPalette.getDoorPaletteObjects().contains(paletteObject)) {
//			System.err.println("someone called setDestinationDoorSpawnPoint with a paletteObject we don't even have!");
			return;
		}
		
		DoorDestinationScreenObject ddso = new DoorDestinationScreenObject(destPoint.x, destPoint.y, paletteObject);
		doorLayerObjects.add(ddso);
		paletteObject.setDestinationPoint(ddso);
		
	}
	
	
	public void setDestinationCommentDoorSpawnPoint(DoorDestinationPaletteObject paletteObject, Point destPoint) {
		
		
		if(!editorPalette.getCommentaryPaletteObjects().contains(paletteObject)) {
//			System.err.println("someone called setDestinationDoorSpawnPoint with a paletteObject we don't even have!");
			return;
		}
		
		DoorDestinationScreenObject ddso = new DoorDestinationScreenObject(destPoint.x, destPoint.y, paletteObject);
		commentaryLayerObjects.add(ddso);
		paletteObject.setDestinationPoint(ddso);
		
	}
	
	
	public void addSourceDoors(ArrayList<SpawnPointAndDepth> sourcePoints, DoorSourcePaletteObject paletteObject) {
		
		if(!editorPalette.getDoorPaletteObjects().contains(paletteObject)) {
//			System.err.println("someone called addSourceDoors with a paletteObject we don't even have!");
			return;
		}
		
		DoorSourceScreenObject tempDoor = null;
		
		for(Point p : sourcePoints) {
			
			tempDoor = new DoorSourceScreenObject(p.x, p.y, paletteObject);
			
			doorLayerObjects.add(tempDoor);
			
		}
		
	}
	
	
	public HashMap<String, DoorLoadData> getCommentDoorLoadPalette() {
		return commentDoorLoadPalette;
	}
	
	

	public void addSourceCommentDoors(ArrayList<SpawnPointAndDepth> sourcePoints, DoorSourcePaletteObject paletteObject) {
		
		if(!editorPalette.getCommentaryPaletteObjects().contains(paletteObject)) {
//			System.err.println("someone called addSourceCommentDoors with a paletteObject we don't even have!");
			return;
		}
		
		DoorSourceScreenObject tempDoor = null;
		
		for(Point p : sourcePoints) {
			
			tempDoor = new DoorSourceScreenObject(p.x, p.y, paletteObject);
			
			commentaryLayerObjects.add(tempDoor);
			
		}
		
	}
	
	public void loadEnemy(BufferedReader in, ArrayList<ScreenObjectAndDepth> enemyLayerFiltered, WidgetCounter counter) throws Exception {
		
		int xPos = -1;
		int yPos = -1;
		int kind = -1;
		int min = -1;
		int max = -1;
		char dir = '\0';
		
		String inputter = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("/enemy"))
				break;
			else if(inputter.contains("#"))
				continue;
			else if(inputter.contains("x:")) {
				xPos = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("y:")) {
				yPos = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("dir:")) {
				dir = inputter.charAt(4);
			} else if(inputter.contains("minX:") || inputter.contains("minY:")) {
				min = Integer.parseInt(inputter.substring(5).trim());
			} else if(inputter.contains("maxX:") || inputter.contains("maxY:")) {
				max = Integer.parseInt(inputter.substring(5).trim());
			} else if(inputter.contains("red")) {
				kind = EnemySprite.STATIONARY;
			} else if(inputter.contains("blue")) {
				kind = EnemySprite.TURRET;
			} else if(inputter.contains("green")) {
				kind = EnemySprite.UP_DOWN;
			} else if(inputter.contains("yellow")) {
				kind = EnemySprite.LIGHTNING;
			} else if(inputter.contains("purple")) {
				kind = EnemySprite.UP_DOWN_TURRET;
			} else if(inputter.contains("gray")) {
				kind = EnemySprite.LEFT_RIGHT;
			} 
			
		}
		
		
		if(xPos == -1 || yPos == -1 || kind == -1) {
//			System.out.println("x, y, or kind wasn't read: " + xPos + ", " + yPos + ", " + kind);
			return;
		}
		
		if((kind != EnemySprite.STATIONARY && kind != EnemySprite.TURRET)
				&& (min == -1 || max == -1)) {
			
//			System.out.println("kind was " + kind + ", min: " + min + ", max: " + max);
			return;
			
		}
		
		
		switch(kind) {
		case EnemySprite.STATIONARY:
//			this.enemyLayerObjects.add(new RedEnemyScreenObject(xPos, yPos, this));
			enemyLayerFiltered.add(new ScreenObjectAndDepth(new RedEnemyScreenObject(xPos, yPos, this), counter.getInt()));
			counter.increment();
			break;
		case EnemySprite.TURRET:
//			this.enemyLayerObjects.add(new BlueEnemyScreenObject(xPos, yPos, this));
			enemyLayerFiltered.add(new ScreenObjectAndDepth(new BlueEnemyScreenObject(xPos, yPos, this), counter.getInt()));
			counter.increment();
			break;
		case EnemySprite.UP_DOWN:
//			this.enemyLayerObjects.add(new GreenEnemyScreenObject(xPos, yPos, this, min, max));
			enemyLayerFiltered.add(new ScreenObjectAndDepth(new GreenEnemyScreenObject(xPos, yPos, this, min, max), counter.getInt()));
			counter.increment();
			break;
		case EnemySprite.LIGHTNING:
//			this.enemyLayerObjects.add(new YellowEnemyScreenObject(xPos, yPos, this, min, max));
			enemyLayerFiltered.add(new ScreenObjectAndDepth(new YellowEnemyScreenObject(xPos, yPos, this, min, max), counter.getInt()));
			counter.increment();
			break;
		case EnemySprite.UP_DOWN_TURRET:
//			this.enemyLayerObjects.add(new VioletEnemyScreenObject(xPos, yPos, this, min, max));
			enemyLayerFiltered.add(new ScreenObjectAndDepth(new VioletEnemyScreenObject(xPos, yPos, this, min, max), counter.getInt()));
			counter.increment();
			break;
		case EnemySprite.LEFT_RIGHT:
//			this.enemyLayerObjects.add(new GrayEnemyScreenObject(xPos, yPos, this, min, max));
			enemyLayerFiltered.add(new ScreenObjectAndDepth(new GrayEnemyScreenObject(xPos, yPos, this, min, max), counter.getInt()));
			counter.increment();
			break;
		}
		
		
		
		
	}
	
	
	public RainbowBossLoadData loadBoss(BufferedReader in) throws Exception {
		
		
		RainbowBossLoadData returnValue = new RainbowBossLoadData();
		
		int xPos = -1;
		int yPos = -1;
		int safeX = -1;
		int safeY = -1;
		int kind = RainbowElementalSprite.NO_SPAWNING;
		
		String inputter = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("/boss"))
				break;
			else if(inputter.contains("#"))
				continue;
			else if(inputter.contains("x:")) {
				xPos = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("y:")) {
				yPos = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("safeX:")) {
				safeX = Integer.parseInt(inputter.substring(6).trim());
			} else if(inputter.contains("safeY:")) {
				safeY = Integer.parseInt(inputter.substring(6).trim());
			} else if(inputter.contains("spawnEnemies")) {
				kind = RainbowElementalSprite.SPAWN_TWO;
			} else if(inputter.contains("spawnSixEnemies")) {
				kind = RainbowElementalSprite.SPAWN_SIX;
			}
			
		}
		
		
		if(xPos == -1 || yPos == -1 || safeX == -1 || safeY == -1) {
//			System.out.println("error while loading up the boss!");
			return null;
		}
		
		returnValue.setFocusX(xPos);
		returnValue.setFocusY(yPos);
		returnValue.setSafeX(safeX);
		returnValue.setSafeY(safeY);
		returnValue.setKind(kind);
		
		return returnValue;
	}
	
	
	
	public void loadRogueBlock(BufferedReader in, HashMap<String, RogueBlockLoadData> rogueBlockLoadPalette, WidgetCounter counter) throws Exception {
		
		RogueBlockLoadData rogueBlockData;
		
		String inputter = null;
		
		int x = -1;
		int y = -1;
		String image = null;
		Color transparentColor = null;
		int width = -1;
		int height = -1;
		Boolean isPassThru = null;
		
		StringBuffer key = new StringBuffer();
		
		while((inputter = in.readLine()) != null) {
			if(inputter.contains("/block"))
				break;
			else if(inputter.contains("#"))
				continue;
			else if(inputter.contains("x:")) {
				x = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("y:")) {
				y = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("graphic:")) {
				image = inputter.substring(8);
				key.append(inputter);
			} else if(inputter.contains("transparent:")) {
				transparentColor = CustomAnimationPanel.convertStringToColor(inputter.substring(12).trim());
				key.append(inputter);
			} else if(inputter.contains("solid")) {
				isPassThru = false;
				key.append(inputter);
			} else if(inputter.contains("passThru")) {
				isPassThru = true;
				key.append(inputter);
			} else if(inputter.contains("width:")) {
				width = Integer.parseInt(inputter.substring(6).trim());
				key.append(inputter);
			} else if(inputter.contains("height:")) {
				height = Integer.parseInt(inputter.substring(7).trim());
				key.append(inputter);
			}
		}
		
		
		if(x == -1 || y == -1 
				|| width == -1 || height == -1
				|| image == null || transparentColor == null
				|| isPassThru == null) {
//			System.err.println("something was null with this rogue block!");
			return;
		}
		
		if(rogueBlockLoadPalette.containsKey(key.toString())) {
			rogueBlockData = rogueBlockLoadPalette.get(key.toString());
			rogueBlockData.addSpawnPoint(new SpawnPointAndDepth(x, y, counter.getInt()));
			counter.increment();
		} else {
			rogueBlockData = new RogueBlockLoadData();
			
			rogueBlockData.setPassThru(isPassThru);
			rogueBlockData.setImage(image);
			rogueBlockData.setTransparent(transparentColor);
			rogueBlockData.setWidth(width);
			rogueBlockData.setHeight(height);
			rogueBlockData.addSpawnPoint(new SpawnPointAndDepth(x, y, counter.getInt()));
			counter.increment();
			
			rogueBlockLoadPalette.put(key.toString(), rogueBlockData);
		}
		
		
		
	}
	
	
	public void loadMovingBlock(BufferedReader in, HashMap<String, MovingBlockLoadData> movingBlockLoadPalette, WidgetCounter counter) throws Exception {
		
		int x = -1;
		int y = -1;
		int speed = -1;
		int defaultSpeed = 0;
		char dir = '\0';
		int width = -1;
		int height = -1;
		Boolean isPassThru = null;
		Boolean isVertical = null;
		int min = -1;
		int max = -1;
		String image = null;
		Color transparentColor = null;
		
		StringBuffer key = new StringBuffer();
		String inputter = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("/movingBlock"))
				break;
			else if(inputter.contains("#")) {
				continue;
			} else if(inputter.contains("x:")) {
				x = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("y:")) {
				y = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("width:")) {
				width = Integer.parseInt(inputter.substring(6).trim());
				key.append(inputter);
			} else if(inputter.contains("height:")) {
				height = Integer.parseInt(inputter.substring(7).trim());
				key.append(inputter);
			} else if(inputter.contains("minX:") || inputter.contains("minY:")) {
				min = Integer.parseInt(inputter.substring(5).trim());
			} else if(inputter.contains("maxX:") || inputter.contains("maxY:")) {
				max = Integer.parseInt(inputter.substring(5).trim());
			} else if(inputter.contains("graphic:")) {
				image = inputter.substring(8).trim();
				key.append(inputter);
			} else if(inputter.contains("transparent:")) {
				transparentColor = CustomAnimationPanel.convertStringToColor(inputter.substring(12).trim());
				key.append(inputter);
			} else if(inputter.contains("solid")) {
				isPassThru = false;
				key.append(inputter);
			} else if(inputter.contains("passThru")) {
				isPassThru = true;
				key.append(inputter);
			} else if(inputter.contains("vertical")) {
				isVertical = true;
				key.append(inputter);
			} else if(inputter.contains("horizontal")) {
				isVertical = false;
				key.append(inputter);
			} else if(inputter.contains("speed:")) {
				speed = Integer.parseInt(inputter.substring(6).trim());
			} else if(inputter.contains("defaultSpeed:")) {
				defaultSpeed = Integer.parseInt(inputter.substring(13).trim());
				key.append(inputter);
			} else if(inputter.contains("dir:")) {
				dir = inputter.charAt(4);
			}
				
			
		}
		
		
		
		if(x == -1 
				|| y == -1
				|| width == -1
				|| height == -1
				|| isVertical == null
				|| isPassThru  == null
				|| speed == -1
				|| dir == '\0' 
				|| image == null
				|| transparentColor == null
				|| min == -1
				|| max == -1) {
			return;
		}
		
		if(movingBlockLoadPalette.containsKey(key.toString())) {
			MovingBlockLoadData mbld = movingBlockLoadPalette.get(key.toString());
			
			MovingBlockPointData p  = new MovingBlockPointData(x, y, speed, dir, min, max, counter.getInt());
			counter.increment();
			mbld.addSpawnPoint(p);
			
		} else {
			
			MovingBlockLoadData mbld = new MovingBlockLoadData(isVertical);
			
			mbld.setDefaultSpeed(defaultSpeed);
			mbld.setDir(dir);
			mbld.setHeight(height);
			mbld.setImage(image);
			mbld.setIsPassThru(isPassThru);
			mbld.setTransparentColor(transparentColor);
			mbld.setVertical(isVertical);
			mbld.setWidth(width);
			
			MovingBlockPointData p  = new MovingBlockPointData(x, y, speed, dir, min, max, counter.getInt());
			counter.increment();
			mbld.addSpawnPoint(p);
			
			movingBlockLoadPalette.put(key.toString(), mbld);
			
		}
		
		
		
	}
	
	
	public void loadHurtzone(BufferedReader in, HashMap<String, HurtzoneLoadData> hurtzoneLoadPalette) throws Exception {
		
//		hurtzone:
//			x:400
//			y:450
//			horizontal
//			min:300
//			max:550
//			duration:4000
//			minTimeBetween:6000
//			chancePerTickNumerator:1
//			chancePerTickDenominator:100
//			warmupTime:2000
//			damage:2
//			minColor:0.15
//			maxColor:0.25
//			/hurtzone
		
		int x = -1;
		int y = -1;
		Boolean isVertical = null;
		int min = -1;
		int max = -1;
		int duration = -1;
		int minTimeBetween = -1;
		int chancePerTickNumerator = -1;
		int chancePerTickDenominator = -1;
		int warmupTime = -1;
		int damage = -1;
		double minColor = Double.NaN;
		double maxColor = Double.NaN;
		
		
		
		StringBuffer key = new StringBuffer();
		String inputter = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("#")) {
				continue;
			}else if(inputter.contains("/hurtzone")) {
				break;
			} else if(inputter.contains("min:")) {
				min = Integer.parseInt(inputter.substring(4).trim());
			} else if(inputter.contains("max:")) {
				max = Integer.parseInt(inputter.substring(4).trim());
			} else if(inputter.contains("x:")) {
				x = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("y:")) {
				y = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("vertical")) {
				isVertical = true;
				key.append(inputter);
			} else if(inputter.contains("horizontal")) {
				isVertical = false;
				key.append(inputter);
			} else if(inputter.contains("duration:")) {
				duration = Integer.parseInt(inputter.substring(9).trim());
				key.append(inputter);
			} else if(inputter.contains("minTimeBetween:")) {
				minTimeBetween = Integer.parseInt(inputter.substring(15).trim());
				key.append(inputter);
			} else if(inputter.contains("chancePerTickNumerator:")) {
				chancePerTickNumerator = Integer.parseInt(inputter.substring(23).trim());
				key.append(inputter);
			} else if(inputter.contains("chancePerTickDenominator:")) {
				chancePerTickDenominator = Integer.parseInt(inputter.substring(25).trim());
				key.append(inputter);
			} else if(inputter.contains("warmupTime:")) {
				warmupTime = Integer.parseInt(inputter.substring(11).trim());
				key.append(inputter);
			} else if(inputter.contains("damage:")) {
				damage = Integer.parseInt(inputter.substring(7).trim());
				key.append(inputter);
			} else if(inputter.contains("minColor:")) {
				minColor = Double.parseDouble(inputter.substring(9).trim());
				key.append(inputter);
			} else if(inputter.contains("maxColor:")) {
				maxColor = Double.parseDouble(inputter.substring(9).trim());
				key.append(inputter);
			}
			
		}
		
		
		if(x == -1
			|| y == -1
			|| isVertical == null
			|| min == -1
			|| max == -1
			|| duration == -1
			|| minTimeBetween == -1
			|| chancePerTickDenominator == -1
			|| chancePerTickNumerator == -1
			|| warmupTime == -1
			|| damage == -1
			|| minColor == Double.NaN
			|| maxColor == Double.NaN) {
			
//			System.out.println("<><>DELME something was missing for a hurtzone!");
//			System.out.println("X:" + x + ", y:" + y + ", isVer " + isVertical + ", min: " + min + ", max: " +max + ", duration: " + duration
//					+ ", minTime: " + minTimeBetween + ", numer: " + chancePerTickNumerator + ", denom: " + chancePerTickDenominator
//					+ ", warmup: " + warmupTime + ", damage: " + damage + ", miniCol: " + minColor + ", maxCo: " + maxColor);
			return; 
		}
		
		
		if(hurtzoneLoadPalette.containsKey(key.toString())) {
			
			HurtzoneLoadData hzld = hurtzoneLoadPalette.get(key.toString());
			HurtzonePointData point = new HurtzonePointData(x, y, min, max);
			hzld.add(point);
			
		} else {
			
			HurtzoneLoadData hzld = new HurtzoneLoadData(duration, minTimeBetween, damage, warmupTime, chancePerTickNumerator, chancePerTickDenominator, minColor, maxColor, isVertical);
			HurtzonePointData point = new HurtzonePointData(x, y, min, max);
			hzld.add(point);
			hurtzoneLoadPalette.put(key.toString(), hzld);
			
		}
		
		
		
		
		
	}
	
	
	public void loadConveyor(BufferedReader in, HashMap<String, ConveyorLoadData> conveyorLoadPalette, WidgetCounter counter) throws Exception {
		
		int width = -1;
		int height = -1;
		int x = -1;
		int y = -1;
		char dir = '\0';
		int speed = -1;
		String imageFiles[] = null;
		int index = -1;
		Color colors[] = null;
		Boolean isPassThru = null;
		
		StringBuffer key = new StringBuffer();
		String strArray[] = null;
		
		String inputter = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("#"))
				continue;
			else if(inputter.contains("/block")) {
				break;
			} else if(imageFiles != null && colors != null && index != -1) {
				strArray = inputter.split("\\*");
				imageFiles[index] = strArray[0].trim();
				colors[index] = CustomAnimationPanel.convertStringToColor(strArray[1].trim());
				index++;
				key.append(inputter);
			} else if(inputter.contains("x:")) {
				x = Integer.parseInt(inputter.substring(2));
			} else if(inputter.contains("y:")) {
				y = Integer.parseInt(inputter.substring(2));
			} else if(inputter.contains("width:")) {
				width = Integer.parseInt(inputter.substring(6));
				key.append(inputter);
			} else if(inputter.contains("height:")) {
				height = Integer.parseInt(inputter.substring(7));
				key.append(inputter);
			} else if(inputter.contains("speed:")) {
				speed = Integer.parseInt(inputter.substring(6));
				key.append(inputter);
			} else if(inputter.contains("dir:")) {
				dir = inputter.charAt(4);
				key.append(inputter);
			} else if(inputter.contains("passThru")) {
				isPassThru = true;
				key.append(inputter);
			} else if(inputter.contains("solid")) {
				isPassThru = false;
				key.append(inputter);
			} else if(inputter.contains("frameCount:")) {
				int arrayLength = Integer.parseInt(inputter.substring(11).trim());
				colors = new Color[arrayLength];
				imageFiles = new String[arrayLength];
				index = 0;
				key.append(inputter);
			}
			
		}
		
		
		
		if(x == -1
				|| y == -1
				|| index == -1
				|| colors == null
				|| imageFiles == null
				|| index != colors.length
				|| index != imageFiles.length
				|| dir == '\0'
				|| speed == -1
				|| width == -1
				|| height == -1) {
			return;
		}
		
		if(conveyorLoadPalette.containsKey(key.toString())) {
			ConveyorLoadData cld = conveyorLoadPalette.get(key.toString());
			cld.addSpawnPoint(new SpawnPointAndDepth(x, y, counter.getInt()));
			counter.increment();
		} else {
			ConveyorLoadData cld = new ConveyorLoadData();
			
			cld.setDir(dir);
			cld.setHeight(height);
			cld.setImages(imageFiles);
			cld.setIsPassThru(isPassThru);
			cld.setSpeed(speed);
			cld.setTransparentColors(colors);
			cld.setWidth(width);
			
			cld.addSpawnPoint(new SpawnPointAndDepth(x, y, counter.getInt()));
			
			conveyorLoadPalette.put(key.toString(), cld);
		}
		
		
	}
	
	
	public GoalLoadData loadGoal(BufferedReader in) throws Exception {
		
		String inputter = null;
		int x = -1;
		int y = -1;
		Boolean isPassThru = null;
		String images[] = null;
		int index = -1;
		boolean enableCommentary = false;
		
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("#"))
				continue;
			else if(inputter.contains("/goal")) {
				break;
			} else if(images != null) {
				images[index++] = inputter.trim();
			} else if(inputter.contains("x:")) {
				x = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("y:")) {
				y = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("passThru")) {
				isPassThru = true;
			} else if(inputter.contains("solid")) {
				isPassThru = false;
			} else if(inputter.contains("endFrames:")) {
				images = new String[Integer.parseInt(inputter.substring(10).trim())];
				index = 0;
			} else if(inputter.contains("commentary")) {
				enableCommentary = true;
			}
			
			
		}
		
		
		if(x == -1 
				|| y == -1
				|| images == null
				|| isPassThru == null
				|| index != images.length) {
			
			return null;
			
		}
		
		
		GoalLoadData returnValue = new GoalLoadData();
		returnValue.setX(x);
		returnValue.setY(y);
		returnValue.setImages(images);
		returnValue.setIsPassThru(isPassThru);
		returnValue.setEnableCommentary(enableCommentary);
		
		
		return returnValue;
		
	}
	
	
	public void cloneCurrentSelection() {
		
//		System.out.println("<><>DELME now in cloneCurrentSelection");
		
		switch(layerControlPanel.getCurrentLayer()) {
		case LayerControlPanel.DOOR_LAYER:
			cloneCurrentSelectionInner(doorLayerObjects);
			break;
		case LayerControlPanel.COMMENTARY_LAYER:
			cloneCurrentSelectionInner(commentaryLayerObjects);
			break;
		case LayerControlPanel.ENEMY_LAYER:
			cloneCurrentSelectionInner(enemyLayerObjects);
			break;
		case LayerControlPanel.WIDGET_LAYER:
			cloneCurrentSelectionInner(widgetLayerObjects);
			break;
		}
		
	}
	
	
	private void cloneCurrentSelectionInner(ArrayList<ScreenObject> relevantList) {
		
		ArrayList<CloneableScreenObject> selectedObjects = new ArrayList<CloneableScreenObject>();
		
		boolean isRadio = false;
		
		for(ScreenObject so : relevantList) {
			if(so.isSelected()) {
				
//				isRadio = false;
//				
//				if(so instanceof RadioScreenObject) {
//					System.out.println("<><>DELME looking at a radio!");
//					isRadio = true;
//				}
				
				if((so instanceof CloneableScreenObject)) {
					selectedObjects.add((CloneableScreenObject)so);
//					if(isRadio)
//						System.out.println("<><>DELME about to add the radio...");
//				} else {
//					if(isRadio)
//						System.out.println("<><>DELME about to add the radio...");
				}
			}
			
		}
		
		
		
		
		if(selectedObjects.size() == 0) {
			JOptionPane.showMessageDialog(null,  "No action taken; no cloneable objects were selected","No objects selected", JOptionPane.WARNING_MESSAGE);
			return;
		}
		
		CloneableScreenObject clone = null;
		for(CloneableScreenObject cso : selectedObjects) {
			clone = cso.clone(this);
			if(clone instanceof ScreenObject) {
				relevantList.add((ScreenObject) clone);
//				System.out.println("the x-min of the cloned object is: " + ((ScreenObject)clone).getClickRect().getMinX());
			}
			if(cso instanceof ScreenObject) {
//				System.out.println("<><>DELME about to move something; class is: " + cso.getClass().getCanonicalName() + " and pre-move x is: " + ((ScreenObject) cso).getClickRect().getMinX());
				((ScreenObject) cso).getClickRect().move(50, 0);
			}
		}
		
		this.repaint();
		
	}
	
	public static class SpawnPointAndDepth extends Point {
		
		public int depth;
		
		
		public SpawnPointAndDepth(int theX, int theY, int theDepth) {
			x = theX;
			y = theY;
			depth = theDepth;
		}
		
	}
	
	private class ScreenObjectAndDepth implements Comparable {
		
		public ScreenObject toBeAdded;
		public int depth;
		
		public ScreenObjectAndDepth(ScreenObject so, int d) {
			toBeAdded = so;
			depth = d;
		}
		
		@Override
		public int compareTo(Object arg0) {
			
			if(!(arg0 instanceof ScreenObjectAndDepth))
				return 0;
			
			ScreenObjectAndDepth other = (ScreenObjectAndDepth) arg0;
			
//			if(this.toBeAdded == null) {
//				System.err.println();
//			}
			
			if(this.toBeAdded.getLayer() == other.toBeAdded.getLayer())
				return this.depth - other.depth;
			else
				return this.toBeAdded.getLayer() - other.toBeAdded.getLayer();
			
		}
		
		
		
		
	}
	
	private class WidgetCounter {
		
		private int theInt = 0;
		
		public int getInt() {
			return theInt;
		}
		
		public void increment() {
			theInt++;
		}
	}
	
	public boolean doesRouteStartToGoalExist(HashSet<String> roomsAlreadyChecked) {
		
		roomsAlreadyChecked.add(this.listItem.getName());
		
		if(widgetLayerObjects != null && widgetLayerObjects.size() > 0) {
			for(ScreenObject so : widgetLayerObjects) {
				if(so instanceof GoalScreenObject) {
					return true;
				}
			}
		}
		
		ArrayList<RoomEditorPanel> roomsToCheckInstance = new ArrayList<RoomEditorPanel>();
		
		
		if(doorLayerObjects != null && doorLayerObjects.size() > 0) {
			for(ScreenObject so : doorLayerObjects) {
				if(so instanceof DoorSourceScreenObject) {
					
					DoorSourceScreenObject dsso = (DoorSourceScreenObject) so;
					
					RoomEditorPanel rep = dsso.getTargetRoomPanel();
					if(rep == null)
						continue;
					
					if(roomsAlreadyChecked.contains(rep.listItem.getName())) {
						continue;
					}
					
					roomsToCheckInstance.add(rep);
					
				}
			}
		}
		
		if(roomsToCheckInstance.isEmpty()) {
			return false;
		}
		
		for(RoomEditorPanel rep : roomsToCheckInstance) {
			
			if(roomsAlreadyChecked.contains(rep.listItem.getName()))
				continue;
			
			if(rep.doesRouteStartToGoalExist(roomsAlreadyChecked)) {
				return true;
			}
			
		}
		
		return false;
		
	}
	
	public boolean containsStartPoint() {
		
		if(widgetLayerObjects == null)
			return false;
		
		for(ScreenObject so : widgetLayerObjects) {
			if(so instanceof LevelStartScreenObject)
				return true;
		}
		
		return false;
	}
	
}
